/*=========================================================================
 Program:   OsiriX
 Copyright (c) 2010 - 2024 Pixmeo SARL
 266 rue de Bernex
 CH-1233 Bernex
 Switzerland
 All rights reserved.
 =========================================================================*/





#import <Cocoa/Cocoa.h>

typedef float itkPixelType;
//typedef itk::RGBPixel<unsigned char> itkPixelType;
typedef itk::Image< itkPixelType, 3 > ImageType;
typedef itk::ImportImageFilter< itkPixelType, 3 > ImportFilterType;


/** \brief Creates an itkImageImportFilter
*/

@interface ITK : NSObject {
	
	// ITK objects	
	ImportFilterType::Pointer importFilter;
}

#ifdef id
#define redefineID
#undef id
#endif


- (id) initWith :(NSArray*) pix :(float*) srcPtr :(long) slice;
- (id) initWithPix :(NSArray*) pix volume:(float*) volumeData sliceCount:(long) slice resampleData:(BOOL)resampleData;

#ifdef redefineID
#define id Id
#undef redefineID
#endif

- (ImportFilterType::Pointer) itkImporter;
- (void)setupImportFilterWithSize:(ImportFilterType::SizeType)size  
	origin:(double[3])origin 
	spacing:(double[3])spacing 
	data:(float *)data
	filterWillOwnBuffer:(BOOL)filterWillOwnBuffer;


@end
